/* global folder, parameters */

// transform string only parameters and adjust value object types
let _parameters = require('/agorum/roi/customers/cdev.ncore/js/utils/parse')(global.parameters);
_parameters.folder = folder;

let $$ = require('/agorum/roi/customers/cdev.ncore/js/utils/debug')({
  debug: _parameters.debugMode || _parameters.debug,
  path: _parameters.action ? _parameters.action + '.js' : '/agorum/roi/customers/cdev.ncore/js/active-folder.js',
  prefix: '[cdev/ncore - active-folder]',
});
$$.objects = require('common/objects');
if (_parameters.rename) {
  $$.fill = require('common/templates').fill;
}

$$.debug(folder.anyFolderPath, {
  parameters: _parameters,
  environment: $$.environment,
});

let active = 'active' in _parameters ? _parameters.active : true;
if (active) {
  let getWorkingDirectory = parameters => {
    if (parameters.workingDirectory) {
      return $$.objects.find(parameters.workingDirectory);
    }
  };

  let action, workflow, move, workflowLib;
  if (_parameters.action) {
    try {
      action = require(_parameters.action);
    } catch (e) {
      throw new Error('action not found: ' + _parameters.action);
    }
    delete _parameters.action;
  } else if (_parameters.workflow) {
    workflow = _parameters.workflow;
    delete _parameters.workflow;
    workflowLib = require('common/workflow');
  } else if (_parameters.move) {
    move = $$.objects.tryFind(_parameters.move);
    if (move === null) {
      if (_parameters.move.contains(':')) {
        move = $$.objects.query(_parameters.move).find()[0];
      }
    }
    if (!move) throw new Error('move target not found: ' + _parameters.move);
    if (!move.isFolder) throw new Error('move target is not a folder: ' + _parameters.move);
    delete _parameters.move;
  } else {
    throw new Error('either action, workflow or move parameter is required!');
  }

  // move files from active folder to working directory
  let workingDirectory = getWorkingDirectory(_parameters);

  let query = ['inpath:' + folder.ID];

  let queryDelay = 0;
  if (_parameters.queryDelay) {
    queryDelay = parseInt(_parameters.queryDelay);
    delete _parameters.queryDelay;
    if (queryDelay > 0) query.push('updatedate:[* TO NOW-' + queryDelay + 'MINUTES]');
  }

  if (_parameters.query) {
    query.push(_parameters.query);
    delete _parameters.query;
  }

  let queryLimit = 100;
  if (_parameters.queryLimit) {
    queryLimit = parseInt(_parameters.queryLimit);
    delete _parameters.queryLimit;
  }
  if (!parameters.entryPoint) _parameters.entryPoint = 'AF';
  if (!parameters.debugMode) _parameters.debugMode = 'true';

  $$.debug(folder.anyFolderPath, {
    query: query,
    queryLimit: queryLimit,
    queryDelay: queryDelay,
  });

  $$.objects
    .query(query.join(' '))
    .limit(queryLimit)
    .find()
    .forEach(obj => {
      $$.debug(folder.anyFolderPath, obj);
      if (workingDirectory) {
        $$.objects.unlink(obj);
        $$.objects.link(obj, workingDirectory);
      }
      if (action) {
        $$.debug(folder.anyFolderPath,{ action: action, parameters: _parameters });
        action(obj, _parameters);
      } else if (workflow) {
        _parameters.sys_acw_attachments = [obj];
        $$.debug(folder.anyFolderPath, { workflow: workflow, parameters: _parameters });
        workflowLib.start(workflow, _parameters);
      } else if (move) {
        $$.objects.unlink(obj);
        let target = move;
        if (_parameters.rename) {
          // rename may contain a path, so need to split and find the last part
          // and the path specification from the rename string
          let rename = $$.fill(_parameters.rename, _parameters, obj);
          let renameParts = rename.split('/');
          rename = renameParts.pop();
          let renamePath = renameParts.join('/');
          if (renamePath) {
            target = move.createPath(renamePath);
            $$.debug(folder.anyFolderPath, { obj: obj, target: target, rename: rename });
            $$.objects.link(obj, target, rename);
          } else {
            $$.debug(folder.anyFolderPath, { obj: obj, target: target });
            $$.objects.link(obj, target);
          }
        } else {
          $$.debug(folder.anyFolderPath,{ obj: obj, target: move });
          $$.objects.link(obj, move);
        }
      }
    });
}

